/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import java.util.Arrays;

public class StringBuilder
implements Appendable,
CharSequence {
    static final int INITIAL_CAPACITY = 16;
    public char[] chars;
    public int length;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    public static int numChars(int value2, int radix) {
        int result2;
        int n = result2 = value2 < 0 ? 2 : 1;
        while ((value2 /= radix) != 0) {
            ++result2;
        }
        return result2;
    }

    public static int numChars(long value2, int radix) {
        int result2;
        int n = result2 = value2 < 0L ? 2 : 1;
        while ((value2 /= (long)radix) != 0L) {
            ++result2;
        }
        return result2;
    }

    final char[] getValue() {
        return this.chars;
    }

    public StringBuilder() {
        this.chars = new char[16];
    }

    public StringBuilder(int capacity) {
        if (capacity < 0) {
            throw new NegativeArraySizeException();
        }
        this.chars = new char[capacity];
    }

    public StringBuilder(CharSequence seq) {
        this(seq.toString());
    }

    public StringBuilder(StringBuilder builder) {
        this.length = builder.length;
        this.chars = new char[this.length + 16];
        System.arraycopy(builder.chars, 0, this.chars, 0, this.length);
    }

    public StringBuilder(String string2) {
        this.length = string2.length();
        this.chars = new char[this.length + 16];
        string2.getChars(0, this.length, this.chars, 0);
    }

    private void enlargeBuffer(int min2) {
        int newSize = (this.chars.length >> 1) + this.chars.length + 2;
        char[] newData = new char[min2 > newSize ? min2 : newSize];
        System.arraycopy(this.chars, 0, newData, 0, this.length);
        this.chars = newData;
    }

    final void appendNull() {
        int newSize = this.length + 4;
        if (newSize > this.chars.length) {
            this.enlargeBuffer(newSize);
        }
        this.chars[this.length++] = 110;
        this.chars[this.length++] = 117;
        this.chars[this.length++] = 108;
        this.chars[this.length++] = 108;
    }

    final void append0(char[] value2) {
        int newSize = this.length + value2.length;
        if (newSize > this.chars.length) {
            this.enlargeBuffer(newSize);
        }
        System.arraycopy(value2, 0, this.chars, this.length, value2.length);
        this.length = newSize;
    }

    final void append0(char[] value2, int offset, int length) {
        if (offset > value2.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset out of bounds: " + offset);
        }
        if (length < 0 || value2.length - offset < length) {
            throw new ArrayIndexOutOfBoundsException("Length out of bounds: " + length);
        }
        int newSize = this.length + length;
        if (newSize > this.chars.length) {
            this.enlargeBuffer(newSize);
        }
        System.arraycopy(value2, offset, this.chars, this.length, length);
        this.length = newSize;
    }

    final void append0(char ch) {
        if (this.length == this.chars.length) {
            this.enlargeBuffer(this.length + 1);
        }
        this.chars[this.length++] = ch;
    }

    final void append0(String string2) {
        if (string2 == null) {
            this.appendNull();
            return;
        }
        int adding = string2.length();
        int newSize = this.length + adding;
        if (newSize > this.chars.length) {
            this.enlargeBuffer(newSize);
        }
        string2.getChars(0, adding, this.chars, this.length);
        this.length = newSize;
    }

    final void append0(CharSequence s2, int start, int end) {
        if (s2 == null) {
            s2 = "null";
        }
        if (start < 0 || end < 0 || start > end || end > s2.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.append0(s2.subSequence(start, end).toString());
    }

    public int capacity() {
        return this.chars.length;
    }

    @Override
    public char charAt(int index2) {
        if (index2 < 0 || index2 >= this.length) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        return this.chars[index2];
    }

    final void delete0(int start, int end) {
        if (start >= 0) {
            if (end > this.length) {
                end = this.length;
            }
            if (end == start) {
                return;
            }
            if (end > start) {
                int count2 = this.length - end;
                if (count2 >= 0) {
                    System.arraycopy(this.chars, end, this.chars, start, count2);
                }
                this.length -= end - start;
                return;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    final void deleteCharAt0(int location) {
        if (0 > location || location >= this.length) {
            throw new StringIndexOutOfBoundsException(location);
        }
        int count2 = this.length - location - 1;
        if (count2 > 0) {
            System.arraycopy(this.chars, location + 1, this.chars, location, count2);
        }
        --this.length;
    }

    public void ensureCapacity(int min2) {
        if (min2 > this.chars.length) {
            int twice = (this.chars.length << 1) + 2;
            this.enlargeBuffer(twice > min2 ? twice : min2);
        }
    }

    public void getChars(int start, int end, char[] dest, int destStart) {
        if (start > this.length || end > this.length || start > end) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.chars, start, dest, destStart, end - start);
    }

    final void insert0(int index2, char[] value2) {
        if (0 > index2 || index2 > this.length) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        if (value2.length != 0) {
            this.move(value2.length, index2);
            System.arraycopy(value2, 0, value2, index2, value2.length);
            this.length += value2.length;
        }
    }

    final void insert0(int index2, char[] value2, int start, int length) {
        if (0 <= index2 && index2 <= length) {
            if (start >= 0 && 0 <= length && length <= value2.length - start) {
                if (length != 0) {
                    this.move(length, index2);
                    System.arraycopy(value2, start, this.chars, index2, length);
                    this.length += length;
                }
                return;
            }
            throw new StringIndexOutOfBoundsException("offset " + start + ", length " + length + ", char[].length " + value2.length);
        }
        throw new StringIndexOutOfBoundsException(index2);
    }

    final void insert0(int index2, char ch) {
        if (0 > index2 || index2 > this.length) {
            throw new ArrayIndexOutOfBoundsException(index2);
        }
        this.move(1, index2);
        this.chars[index2] = ch;
        ++this.length;
    }

    final void insert0(int index2, String string2) {
        if (0 <= index2 && index2 <= this.length) {
            int min2;
            if (string2 == null) {
                string2 = "null";
            }
            if ((min2 = string2.length()) != 0) {
                this.move(min2, index2);
                string2.getChars(0, min2, this.chars, index2);
                this.length += min2;
            }
        } else {
            throw new StringIndexOutOfBoundsException(index2);
        }
    }

    final void insert0(int index2, CharSequence s2, int start, int end) {
        if (s2 == null) {
            s2 = "null";
        }
        if (index2 < 0 || index2 > this.length || start < 0 || end < 0 || start > end || end > s2.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.insert0(index2, s2.subSequence(start, end).toString());
    }

    @Override
    public int length() {
        return this.length;
    }

    private void move(int size2, int index2) {
        if (this.chars.length - this.length >= size2) {
            System.arraycopy(this.chars, index2, this.chars, index2 + size2, this.length - index2);
            return;
        }
        int a = this.length + size2;
        int b = (this.chars.length << 1) + 2;
        int newSize = a > b ? a : b;
        char[] newData = new char[newSize];
        System.arraycopy(this.chars, 0, newData, 0, index2);
        System.arraycopy(this.chars, index2, newData, index2 + size2, this.length - index2);
        this.chars = newData;
    }

    final void replace0(int start, int end, String string2) {
        if (start >= 0) {
            if (end > this.length) {
                end = this.length;
            }
            if (end > start) {
                int stringLength = string2.length();
                int diff2 = end - start - stringLength;
                if (diff2 > 0) {
                    System.arraycopy(this.chars, end, this.chars, start + stringLength, this.length - end);
                } else if (diff2 < 0) {
                    this.move(-diff2, end);
                }
                string2.getChars(0, stringLength, this.chars, start);
                this.length -= diff2;
                return;
            }
            if (start == end) {
                if (string2 == null) {
                    throw new NullPointerException();
                }
                this.insert0(start, string2);
                return;
            }
        }
        throw new StringIndexOutOfBoundsException();
    }

    final void reverse0() {
        if (this.length < 2) {
            return;
        }
        int end = this.length - 1;
        char frontHigh = this.chars[0];
        char endLow = this.chars[end];
        boolean allowFrontSur = true;
        boolean allowEndSur = true;
        int i = 0;
        int mid = this.length / 2;
        while (i < mid) {
            boolean surAtFront;
            char frontLow = this.chars[i + 1];
            char endHigh = this.chars[end - 1];
            boolean bl = surAtFront = allowFrontSur && frontLow >= '\udc00' && frontLow <= '\udfff' && frontHigh >= '\ud800' && frontHigh <= '\udbff';
            if (surAtFront && this.length < 3) {
                return;
            }
            boolean surAtEnd = allowEndSur && endHigh >= '\ud800' && endHigh <= '\udbff' && endLow >= '\udc00' && endLow <= '\udfff';
            allowEndSur = true;
            allowFrontSur = true;
            if (surAtFront == surAtEnd) {
                if (surAtFront) {
                    this.chars[end] = frontLow;
                    this.chars[end - 1] = frontHigh;
                    this.chars[i] = endHigh;
                    this.chars[i + 1] = endLow;
                    frontHigh = this.chars[i + 2];
                    endLow = this.chars[end - 2];
                    ++i;
                    --end;
                } else {
                    this.chars[end] = frontHigh;
                    this.chars[i] = endLow;
                    frontHigh = frontLow;
                    endLow = endHigh;
                }
            } else if (surAtFront) {
                this.chars[end] = frontLow;
                this.chars[i] = endLow;
                endLow = endHigh;
                allowFrontSur = false;
            } else {
                this.chars[end] = frontHigh;
                this.chars[i] = endHigh;
                frontHigh = frontLow;
                allowEndSur = false;
            }
            ++i;
            --end;
        }
        if (!((this.length & 1) != 1 || allowFrontSur && allowEndSur)) {
            this.chars[end] = allowFrontSur ? endLow : frontHigh;
        }
    }

    public void setCharAt(int index2, char ch) {
        if (0 > index2 || index2 >= this.length) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        this.chars[index2] = ch;
    }

    public void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.chars.length) {
            this.enlargeBuffer(newLength);
        } else if (this.length < newLength) {
            Arrays.fill(this.chars, this.length, newLength, '\u0000');
        }
        this.length = newLength;
    }

    public String substring(int start) {
        if (0 <= start && start <= this.length) {
            if (start == this.length) {
                return "";
            }
            return new String(this.chars, start, this.length - start);
        }
        throw new StringIndexOutOfBoundsException(start);
    }

    public String substring(int start, int end) {
        if (0 <= start && start <= end && end <= this.length) {
            if (start == end) {
                return "";
            }
            return new String(this.chars, start, end - start);
        }
        throw new StringIndexOutOfBoundsException();
    }

    @Override
    public String toString() {
        if (this.length == 0) {
            return "";
        }
        return new String(this.chars, 0, this.length);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public int indexOf(String string2) {
        return this.indexOf(string2, 0);
    }

    public int indexOf(String subString, int start) {
        int subCount;
        if (start < 0) {
            start = 0;
        }
        if ((subCount = subString.length()) > 0) {
            if (subCount + start > this.length) {
                return -1;
            }
            char firstChar = subString.charAt(0);
            while (true) {
                int i;
                boolean found = false;
                for (i = start; i < this.length; ++i) {
                    if (this.chars[i] != firstChar) continue;
                    found = true;
                    break;
                }
                if (!found || subCount + i > this.length) {
                    return -1;
                }
                int o1 = i;
                int o2 = 0;
                while (++o2 < subCount && this.chars[++o1] == subString.charAt(o2)) {
                }
                if (o2 == subCount) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < this.length || start == 0 ? start : this.length;
    }

    public int lastIndexOf(String string2) {
        return this.lastIndexOf(string2, this.length);
    }

    public int lastIndexOf(String subString, int start) {
        int subCount = subString.length();
        if (subCount <= this.length && start >= 0) {
            if (subCount > 0) {
                if (start > this.length - subCount) {
                    start = this.length - subCount;
                }
                char firstChar = subString.charAt(0);
                while (true) {
                    int i;
                    boolean found = false;
                    for (i = start; i >= 0; --i) {
                        if (this.chars[i] != firstChar) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return -1;
                    }
                    int o1 = i;
                    int o2 = 0;
                    while (++o2 < subCount && this.chars[++o1] == subString.charAt(o2)) {
                    }
                    if (o2 == subCount) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < this.length ? start : this.length;
        }
        return -1;
    }

    public void trimToSize() {
        if (this.length < this.chars.length) {
            char[] newValue = new char[this.length];
            System.arraycopy(this.chars, 0, newValue, 0, this.length);
            this.chars = newValue;
        }
    }

    public int codePointAt(int index2) {
        if (index2 < 0 || index2 >= this.length) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        return Character.codePointAt(this.chars, index2, this.length);
    }

    public int codePointBefore(int index2) {
        if (index2 < 1 || index2 > this.length) {
            throw new StringIndexOutOfBoundsException(index2);
        }
        return Character.codePointBefore(this.chars, index2);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex > this.length || beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException();
        }
        return Character.codePointCount(this.chars, beginIndex, endIndex - beginIndex);
    }

    public int offsetByCodePoints(int index2, int codePointOffset) {
        return Character.offsetByCodePoints(this.chars, 0, this.length, index2, codePointOffset);
    }

    public StringBuilder append(boolean b) {
        this.append0(b ? "true" : "false");
        return this;
    }

    @Override
    public StringBuilder append(char c) {
        this.append0(c);
        return this;
    }

    public StringBuilder append(int value2) {
        return this.append(value2, 0);
    }

    public StringBuilder append(int value2, int minLength) {
        return this.append(value2, minLength, '0');
    }

    public StringBuilder append(int value2, int minLength, char prefix) {
        if (value2 == Integer.MIN_VALUE) {
            this.append0("-2147483648");
            return this;
        }
        if (value2 < 0) {
            this.append0('-');
            value2 = -value2;
        }
        if (minLength > 1) {
            for (int j = minLength - StringBuilder.numChars(value2, 10); j > 0; --j) {
                this.append(prefix);
            }
        }
        if (value2 >= 10000) {
            if (value2 >= 1000000000) {
                this.append0(digits[(int)((long)value2 % 10000000000L / 1000000000L)]);
            }
            if (value2 >= 100000000) {
                this.append0(digits[value2 % 1000000000 / 100000000]);
            }
            if (value2 >= 10000000) {
                this.append0(digits[value2 % 100000000 / 10000000]);
            }
            if (value2 >= 1000000) {
                this.append0(digits[value2 % 10000000 / 1000000]);
            }
            if (value2 >= 100000) {
                this.append0(digits[value2 % 1000000 / 100000]);
            }
            this.append0(digits[value2 % 100000 / 10000]);
        }
        if (value2 >= 1000) {
            this.append0(digits[value2 % 10000 / 1000]);
        }
        if (value2 >= 100) {
            this.append0(digits[value2 % 1000 / 100]);
        }
        if (value2 >= 10) {
            this.append0(digits[value2 % 100 / 10]);
        }
        this.append0(digits[value2 % 10]);
        return this;
    }

    public StringBuilder append(long value2) {
        return this.append(value2, 0);
    }

    public StringBuilder append(long value2, int minLength) {
        return this.append(value2, minLength, '0');
    }

    public StringBuilder append(long value2, int minLength, char prefix) {
        if (value2 == Long.MIN_VALUE) {
            this.append0("-9223372036854775808");
            return this;
        }
        if (value2 < 0L) {
            this.append0('-');
            value2 = -value2;
        }
        if (minLength > 1) {
            for (int j = minLength - StringBuilder.numChars(value2, 10); j > 0; --j) {
                this.append(prefix);
            }
        }
        if (value2 >= 10000L) {
            if (value2 >= 1000000000000000000L) {
                this.append0(digits[(int)((double)value2 % 1.0E19 / 1.0E18)]);
            }
            if (value2 >= 100000000000000000L) {
                this.append0(digits[(int)(value2 % 1000000000000000000L / 100000000000000000L)]);
            }
            if (value2 >= 10000000000000000L) {
                this.append0(digits[(int)(value2 % 100000000000000000L / 10000000000000000L)]);
            }
            if (value2 >= 1000000000000000L) {
                this.append0(digits[(int)(value2 % 10000000000000000L / 1000000000000000L)]);
            }
            if (value2 >= 100000000000000L) {
                this.append0(digits[(int)(value2 % 1000000000000000L / 100000000000000L)]);
            }
            if (value2 >= 10000000000000L) {
                this.append0(digits[(int)(value2 % 100000000000000L / 10000000000000L)]);
            }
            if (value2 >= 1000000000000L) {
                this.append0(digits[(int)(value2 % 10000000000000L / 1000000000000L)]);
            }
            if (value2 >= 100000000000L) {
                this.append0(digits[(int)(value2 % 1000000000000L / 100000000000L)]);
            }
            if (value2 >= 10000000000L) {
                this.append0(digits[(int)(value2 % 100000000000L / 10000000000L)]);
            }
            if (value2 >= 1000000000L) {
                this.append0(digits[(int)(value2 % 10000000000L / 1000000000L)]);
            }
            if (value2 >= 100000000L) {
                this.append0(digits[(int)(value2 % 1000000000L / 100000000L)]);
            }
            if (value2 >= 10000000L) {
                this.append0(digits[(int)(value2 % 100000000L / 10000000L)]);
            }
            if (value2 >= 1000000L) {
                this.append0(digits[(int)(value2 % 10000000L / 1000000L)]);
            }
            if (value2 >= 100000L) {
                this.append0(digits[(int)(value2 % 1000000L / 100000L)]);
            }
            this.append0(digits[(int)(value2 % 100000L / 10000L)]);
        }
        if (value2 >= 1000L) {
            this.append0(digits[(int)(value2 % 10000L / 1000L)]);
        }
        if (value2 >= 100L) {
            this.append0(digits[(int)(value2 % 1000L / 100L)]);
        }
        if (value2 >= 10L) {
            this.append0(digits[(int)(value2 % 100L / 10L)]);
        }
        this.append0(digits[(int)(value2 % 10L)]);
        return this;
    }

    public StringBuilder append(float f2) {
        this.append0(Float.toString(f2));
        return this;
    }

    public StringBuilder append(double d) {
        this.append0(Double.toString(d));
        return this;
    }

    public StringBuilder append(Object obj) {
        if (obj == null) {
            this.appendNull();
        } else {
            this.append0(obj.toString());
        }
        return this;
    }

    public StringBuilder append(String str) {
        this.append0(str);
        return this;
    }

    public StringBuilder append(char[] ch) {
        this.append0(ch);
        return this;
    }

    public StringBuilder append(char[] str, int offset, int len) {
        this.append0(str, offset, len);
        return this;
    }

    @Override
    public StringBuilder append(CharSequence csq) {
        if (csq == null) {
            this.appendNull();
        } else if (csq instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)csq;
            this.append0(builder.chars, 0, builder.length);
        } else {
            this.append0(csq.toString());
        }
        return this;
    }

    public StringBuilder append(StringBuilder builder) {
        if (builder == null) {
            this.appendNull();
        } else {
            this.append0(builder.chars, 0, builder.length);
        }
        return this;
    }

    @Override
    public StringBuilder append(CharSequence csq, int start, int end) {
        this.append0(csq, start, end);
        return this;
    }

    public StringBuilder append(StringBuilder builder, int start, int end) {
        if (builder == null) {
            this.appendNull();
        } else {
            this.append0(builder.chars, start, end);
        }
        return this;
    }

    public StringBuilder appendCodePoint(int codePoint) {
        this.append0(Character.toChars(codePoint));
        return this;
    }

    public StringBuilder delete(int start, int end) {
        this.delete0(start, end);
        return this;
    }

    public StringBuilder deleteCharAt(int index2) {
        this.deleteCharAt0(index2);
        return this;
    }

    public StringBuilder insert(int offset, boolean b) {
        this.insert0(offset, b ? "true" : "false");
        return this;
    }

    public StringBuilder insert(int offset, char c) {
        this.insert0(offset, c);
        return this;
    }

    public StringBuilder insert(int offset, int i) {
        this.insert0(offset, Integer.toString(i));
        return this;
    }

    public StringBuilder insert(int offset, long l) {
        this.insert0(offset, Long.toString(l));
        return this;
    }

    public StringBuilder insert(int offset, float f2) {
        this.insert0(offset, Float.toString(f2));
        return this;
    }

    public StringBuilder insert(int offset, double d) {
        this.insert0(offset, Double.toString(d));
        return this;
    }

    public StringBuilder insert(int offset, Object obj) {
        this.insert0(offset, obj == null ? "null" : obj.toString());
        return this;
    }

    public StringBuilder insert(int offset, String str) {
        this.insert0(offset, str);
        return this;
    }

    public StringBuilder insert(int offset, char[] ch) {
        this.insert0(offset, ch);
        return this;
    }

    public StringBuilder insert(int offset, char[] str, int strOffset, int strLen) {
        this.insert0(offset, str, strOffset, strLen);
        return this;
    }

    public StringBuilder insert(int offset, CharSequence s2) {
        this.insert0(offset, s2 == null ? "null" : s2.toString());
        return this;
    }

    public StringBuilder insert(int offset, CharSequence s2, int start, int end) {
        this.insert0(offset, s2, start, end);
        return this;
    }

    public StringBuilder replace(int start, int end, String str) {
        this.replace0(start, end, str);
        return this;
    }

    public StringBuilder replace(String find2, String replace) {
        int findLength = find2.length();
        int replaceLength = replace.length();
        int index2 = 0;
        while ((index2 = this.indexOf(find2, index2)) != -1) {
            this.replace0(index2, index2 + findLength, replace);
            index2 += replaceLength;
        }
        return this;
    }

    public StringBuilder replace(char find2, String replace) {
        int replaceLength = replace.length();
        int index2 = 0;
        while (index2 != this.length) {
            if (this.chars[index2] != find2) {
                ++index2;
                continue;
            }
            this.replace0(index2, index2 + 1, replace);
            index2 += replaceLength;
        }
        return this;
    }

    public StringBuilder reverse() {
        this.reverse0();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 + this.length;
        result2 = 31 * result2 + Arrays.hashCode(this.chars);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringBuilder other = (StringBuilder)obj;
        int length = this.length;
        if (length != other.length) {
            return false;
        }
        char[] chars = this.chars;
        char[] chars2 = other.chars;
        if (chars == chars2) {
            return true;
        }
        if (chars == null || chars2 == null) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (chars[i] == chars2[i]) continue;
            return false;
        }
        return true;
    }
}

